/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.gui.dialogs;

import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.BevelBorder;
import net.miginfocom.swing.MigLayout;
import net.nooj4nlp.controller.CorpusEditorShell.ExportXmlDialog.ExportAnnotatedToXmlButtonActionListener;
import net.nooj4nlp.controller.CorpusEditorShell.ExportXmlDialog.XmlAnnotationsListener;
import net.nooj4nlp.controller.TextEditorShell.TextEditorShellController;
import net.nooj4nlp.gui.main.Launcher;

public class ExportXmlDialog
extends JInternalFrame {
    private static final long serialVersionUID = -4146892505648063492L;
    private TextEditorShellController textController;
    private boolean isCorpus;
    private JTextPane textPane;
    private JRadioButton rdbtnAllSyntax;
    private JRadioButton rdbtnList;
    private JComboBox cobxXmlAnnotations;
    private JCheckBox chbxOnly;
    private JButton btnExport;

    public ExportXmlDialog(TextEditorShellController textController, boolean isCorpus) {
        this.textController = textController;
        this.isCorpus = isCorpus;
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setClosable(true);
        this.setBounds(140, 140, 650, 350);
        this.getContentPane().setLayout((LayoutManager)new MigLayout("", "[grow][100!]", "[150!,grow][20!,grow][20!,grow][20!,grow][20!,grow]"));
        this.setTitle("Export " + textController.getTextName());
        this.textPane = new JTextPane();
        this.textPane.setText(Launcher.getXmlAnnotationsTextPaneResources().getText().toString());
        JScrollPane scrollPane = new JScrollPane(this.textPane, 22, 30);
        scrollPane.setBorder(new BevelBorder(1, null, null, null, null));
        this.textPane.setCaretPosition(0);
        this.getContentPane().add((Component)scrollPane, "cell 0 0,grow, span 2");
        this.rdbtnAllSyntax = new JRadioButton("Tag all syntactic annotations");
        this.rdbtnAllSyntax.setSelected(true);
        this.getContentPane().add((Component)this.rdbtnAllSyntax, "cell 0 1, span 2");
        this.rdbtnList = new JRadioButton("Tag only following annotations (click arrow for examples)");
        this.getContentPane().add((Component)this.rdbtnList, "cell 0 2, span 2");
        ButtonGroup rdbtnGroup = new ButtonGroup();
        rdbtnGroup.add(this.rdbtnAllSyntax);
        rdbtnGroup.add(this.rdbtnList);
        XmlAnnotationsListener xal = new XmlAnnotationsListener(this);
        this.rdbtnAllSyntax.addActionListener(xal);
        this.rdbtnList.addActionListener(xal);
        String[] cobxStrings = new String[]{"<header> <title> <p>", "<N>", "<SENTENCE> <NP>", "<TIMEX> <ENAMEX>", "", "<TRANS+FR>"};
        this.cobxXmlAnnotations = new JComboBox<String>(cobxStrings);
        this.cobxXmlAnnotations.setSelectedIndex(4);
        this.cobxXmlAnnotations.setEnabled(false);
        this.cobxXmlAnnotations.setFont(Launcher.preferences.DFont);
        this.getContentPane().add((Component)this.cobxXmlAnnotations, "cell 0 3,growx, span 2");
        this.chbxOnly = new JCheckBox("Export Annotated Text Only (ignore non-annotated text)");
        this.getContentPane().add((Component)this.chbxOnly, "cell 0 4");
        this.btnExport = new JButton("Export");
        this.getContentPane().add((Component)this.btnExport, "cell 1 4, alignx right");
        this.btnExport.addActionListener(new ExportAnnotatedToXmlButtonActionListener(this));
    }

    public JRadioButton getRdbtnAllSyntax() {
        return this.rdbtnAllSyntax;
    }

    public JRadioButton getRdbtnList() {
        return this.rdbtnList;
    }

    public JComboBox getCobxXmlAnnotations() {
        return this.cobxXmlAnnotations;
    }

    public JCheckBox getChbxOnly() {
        return this.chbxOnly;
    }

    public TextEditorShellController getTextController() {
        return this.textController;
    }

    public boolean isCorpus() {
        return this.isCorpus;
    }
}

